//==============================================================
//	Sliderpad
//	2013.11.10
//==============================================================

#include "pins_arduino.h"
#include "TouchSlider.h"

TouchSliderClass TouchSlider;

//各パッドの基準値
uint16_t* Nref;

//各パッドの変化量最大値
uint16_t* Dmax;

//各パッドの変化量の合計
uint32_t Dcount_sld;

//各パッドごとの変化量
int16_t Dcount[CHCOUNT];

//過去の検出ログ(値域:100～600)
int16_t ValueLog[LOGCOUNT];

bool TouchSliderClass::init(uint16_t* nref, uint16_t* dmax) {
	int i;
	
	Nref = nref;
	Dmax = dmax;
	
	//入力設定
	DDR &= ~(1<<CH0);
	DDR &= ~(1<<CH1);
	DDR &= ~(1<<CH2);
	DDR &= ~(1<<CH3);
	DDR &= ~(1<<CH4);
	DDR &= ~(1<<CH5);
	
	//デジタル入力を無効化
	DIDR0 |= (1<<ADC0D);
	DIDR0 |= (1<<ADC1D);
	DIDR0 |= (1<<ADC2D);
	DIDR0 |= (1<<ADC3D);
	DIDR0 |= (1<<ADC4D);
	DIDR0 |= (1<<ADC5D);
	
	//内部プルアップ無効化
	PORT &= ~(1<<CH0);
	PORT &= ~(1<<CH1);
	PORT &= ~(1<<CH2);
	PORT &= ~(1<<CH3);
	PORT &= ~(1<<CH4);
	PORT &= ~(1<<CH5);

	//基準電圧設定
	//select AVCC(01)
	ADMUX &= ~(1<<REFS1);
	ADMUX |= (1<<REFS0);
	
	//AD ON
	ADCSRA |= (1<<ADEN);
	
	//プリスケーラ設定
	ADCSRA &= 0xf8;
	ADCSRA |= 2;
	
	//最小値でクリア
	for(i = 0; i < LOGCOUNT; i++)
	{
		ValueLog[i] = 100;
	}
	
	return true;
}

//スライダの値とるよ
//min:取得最小値
//max:取得最大値
uint16_t TouchSliderClass::readSldVal(uint16_t min,uint16_t max)
{
	uint8_t i;
	int16_t tmp; 
	uint16_t result;
	
	//各パッドの変化量計算
	for(i = 0; i < CHCOUNT; i++)
	{
		//平均で取得
		tmp = Nref[i] - readAve(i,SAMPLECOUNT);
		Dcount[i] = abs(tmp);
	}
	
	if(isTouch() == false)
	{
		//Serial.println("noTouch" );
		//最小値を返すよ
		//result = MINVALUE;
		//前回値を返すよ
		result = ValueLog[0];
	}
	else
	{
		//移動平均算出
		//タッチの値が細かく変化するのを防ぐよ
		ValueLog[0] = calcSldPos();
		for(i = 1; i < LOGCOUNT; i++)
		{
			ValueLog[0] = ValueLog[0] + ValueLog[i];
			
		}
		ValueLog[0] = ValueLog[0] / LOGCOUNT;
		
		//算出値をログに記録
		for(i = LOGCOUNT - 1; 0 < i; i--)
		{
			ValueLog[i] = ValueLog[i - 1];
		}
		
		result = ValueLog[0];
	}
	
	result = map(result, MINVALUE, MAXVALUE, min, max );
	
	return result;
}

//CVD方式でタッチ平均値取るよ
//ch:値を取得するch
//count:サンプリング回数
uint16_t TouchSliderClass::readAve(uint8_t ch,uint16_t count)
{
	uint16_t i;
	uint32_t sum;
	uint16_t ave;
	
	//Choldを充電するのに使用するch
	uint8_t chargeChold[CHCOUNT] = {CH5,CH0,CH1,CH2,CH3,CH4};
	
	sum = 0;
	for(i = 1; i <= count; i++)
	{
		//CholdをAVCCで充電
		DDR |= (1<<chargeChold[ch]);
		PORT |= (1<<chargeChold[ch]);
		ADMUX = (ADMUX & 0xf0) | chargeChold[ch];
		
		DDR |= (1<<ch);
		PORT &= ~(1<<ch);
		
		delayMicroseconds(5);
		
		DDR &= ~(1<<ch);
		PORT &= ~(1<<ch);
		
		delayMicroseconds(5);
		
		ADMUX = (ADMUX & 0xf0) | ch;
		
		delayMicroseconds(5);
		
		//ADC開始
		ADCSRA |= (1<<ADSC);
		
		//変換完了まで待ち
		while( (ADCSRA & (1<<ADSC)) != 0);
		
		sum += ADC;
	}
	
	ave = sum/count;
	
	return ave;
}

//全タッチチェック
//何かタッチされてたらtrueを返すよ
bool TouchSliderClass::isTouch()
{
	uint8_t i;
	
	Dcount_sld=0;
	
	for(i = 0; i < CHCOUNT; i++)
	{
		Dcount_sld += Dcount[i];
	}
	
	if( Dcount_sld < DETECTDELTA)
	{
		return false;
	}
	else
	{
		return true;
	}
}

//位置計算
//スライダのタッチ位置を計算して100～600の範囲で返すよ
uint16_t TouchSliderClass::calcSldPos()
{
	uint8_t i;
	uint16_t result;
	float Dmag[CHCOUNT];
	float DmagSum1,DmagSum2;
	
	DmagSum1 = 0;
	DmagSum2 = 0;
	for(i = 0; i < CHCOUNT; i++)
	{
		DmagSum1 += (Dcount[i]) * (i+1);
		DmagSum2 += (Dcount[i]);
	}
	
	result = (DmagSum1/DmagSum2) * 100;
	return result;
}
