#ifndef _TOUCH_H_INCLUDED
#define _TOUCH_H_INCLUDED

#include <stdio.h>
#include <Arduino.h>
#include <avr/pgmspace.h>

#define PORT PORTC
#define PIN PINC
#define DDR DDRC

#define CH0		0
#define CH1		1
#define CH2		2
#define CH3		3
#define CH4		4
#define CH5		5

#define LOGCOUNT 5
#define CHCOUNT 6

#define DETECTDELTA 40
#define MINVALUE 100
#define MAXVALUE 600
#define SAMPLECOUNT 32

class TouchSliderClass {
public:
  static bool init(uint16_t* nref, uint16_t* dmax);
  static uint16_t readSldVal(uint16_t min,uint16_t max);
private:
  static uint16_t readAve(uint8_t ch,uint16_t count);
  static bool isTouch();
  static uint16_t calcSldPos();
};

extern TouchSliderClass TouchSlider;


#endif
