#include <TouchSlider.h>
#include <SPI.h>
#include <TouchSlider.h>
#include <LiquidCrystal.h>

#define USE_SERIAL 

void volChange(int i);
void DispVol(int i);

#ifndef USE_SERIAL
LiquidCrystal lcd(7, 6, 5, 4, 3, 2, 1);
#endif

volatile int value = 0;
volatile int pre =95;
static char dispstr1[17];
static char dispstr2[17];

uint16_t ref[6]={538,491,484,482,370,386};
uint16_t deltaMax[6]={360,330,320,280,195,250};

void setup()  
{
#ifdef USE_SERIAL
   Serial.begin(9600);
#else
  lcd.begin(16, 2);
#endif

  TouchSlider.init(ref,deltaMax);
   SPI.begin() ;                        // ＳＰＩを行う為の初期化
   SPI.setBitOrder(MSBFIRST) ;          // ビットオーダー
   SPI.setClockDivider(SPI_CLOCK_DIV16);// クロック(CLK)をシステムクロックの1/4で使用(16MHz/8)
   SPI.setDataMode(SPI_MODE2) ;         // クロック極性０(LOW)　クロック位相１()
   //delay(1000) ;
}

void loop()
{
  value = TouchSlider.readSldVal(0,95);
  value = abs(95-value);
  if(pre != value)
  {
    volChange(value);
    pre = value;
    DispVol(value);
  }
}

void volChange(int i)
{
  digitalWrite(10,LOW);                    //右側ボリューム
  SPI.transfer(i);
  SPI.transfer(B00000000);
  digitalWrite(10,HIGH);
   
  delay(10);
  digitalWrite(10,LOW);                    //左側ボリューム
  SPI.transfer(i);
  SPI.transfer(B00010000);
  digitalWrite(10,HIGH);
  delay(10);
  //Serial.println(i);
}

void DispVol(int i)
{
  int dispvalue1;
  int dispvalue2;
  int j;
  
  dispvalue1 = map(i,0,95,0,16);
  dispvalue1 = abs(16-dispvalue1);
  
#ifdef USE_SERIAL
#else
  lcd.clear();
#endif
  
  for(j = 0; j < 16; j++)
  {
    if(j < dispvalue1)
    {
      dispstr1[j]='>';
    }
    else
    {
      dispstr1[j]='.';
    }
  }
  dispstr1[17] = '\0';

#ifdef USE_SERIAL
  Serial.println("---------------------");
  Serial.println(dispstr1);
#else
  lcd.setCursor(0, 0);
  lcd.print(dispstr1);
#endif
  
  memset(dispstr2,0,16);
  dispvalue2 = i;
  sprintf(dispstr2,"-%ddB",dispvalue2);
  

#ifdef USE_SERIAL
  Serial.println(dispstr2);
  Serial.println("---------------------");
#else
  lcd.setCursor(0, 1);
  lcd.print(dispstr2);
#endif
}
